Rem PathEffects.vbs
Rem An InDesign VBScript
Rem
Rem Effects:
Rem Punk: Pushes the control handles on all of the points on the path toward the geometric center of the path.
Rem Bloat: Pushes the control handles on all of the points on the path away from the geometric enter of the path.
Rem PunkBloat: Pushes the left direction handle toward the center of the path and pushes the
Rem right direction handle away from the center of the path.
Rem BloatPunk: Pushes the right direction handle toward the center of the path and pushes the left
Rem direction handle away from the center of the path.
Rem Twirl: Pushes all right direction handles toward the center of the path and leaves the left direction handle unchanged.
Rem AntiTwirl: Pushes all left direction handles toward the center of the path and leaves the right direction handles unchanged.
Rem Retract All: Retracts all control handles.
Rem MakeRectangle: Converts the selected object to a rectangle.
Rem MakeOval: Converts the selected object to an oval.
Rem Turn on the Copy Path option to apply the effect to a duplicate of the selected path(s).
Rem Note that some settings for some of these effects are mathematically equivalent. For example, choosing Bloat and
Rem setting the Distance from Center Point field to -50 is the same as choosing Punk and setting the Offset from
Rem Center Point field to 50.
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem or visit the InDesign scripting user to user forum at http://www.adobeforums.com.
Rem
main
Function main()
	ReDim myObjectList(0)
	Set myInDesign = CreateObject("InDesign.Application.2021")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll	
	myInDesign.Activate
	If myInDesign.Documents.Count <> 0 Then
		If myInDesign.Selection.Count <> 0 Then
			For myCounter = 1 To myInDesign.Selection.Count
					Select Case TypeName(myInDesign.Selection.Item(myCounter))
					Case "Rectangle", "Oval", "Polygon", "GraphicLine"
						If Not (IsEmpty(myObjectList(0))) Then
							ReDim Preserve myObjectList(UBound(myObjectList) + 1)
						End If
						Set myObjectList(UBound(myObjectList)) = myInDesign.Selection.Item(myCounter)
				End Select
			Next
			If Not (IsEmpty(myObjectList(0))) Then
				myDisplayDialog myInDesign, myObjectList
			Else
				MsgBox ("Please select a rectangle, oval, polygon, or graphic line and try again.")
			End If
		Else
			MsgBox ("Please select an object and try again.")
		End If
	Else
		MsgBox ("Please open a document, select an object, and try again.")
	End If
End function
Function myDisplayDialog(myInDesign, myObjectList)
    Set myDialog = myInDesign.Dialogs.Add
    With myDialog
        With .dialogColumns.Add
            With .borderpanels.Add
                With .statictexts.Add
                    .staticLabel = "Effect:"
                End With
                Set myPathEffectButtons = .radiobuttonGroups.Add
                With myPathEffectButtons
                    With .radiobuttonControls.Add
                        .staticLabel = "Punk"
                        .checkedState = True
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "Bloat"
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "PunkBloat"
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "BloatPunk"
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "Twirl"
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "AntiTwirl"
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "RetractAll"
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "MakeRectangle"
                    End With
                    With .radiobuttonControls.Add
                        .staticLabel = "MakeOval"
                    End With
                End With
            End With
            With .borderpanels.Add
                With .statictexts.Add
                    .staticLabel = "Options:"
                End With
                With .dialogColumns.Add
                    With .statictexts.Add
                        .staticLabel = "Offset from Center Point:"
                    End With
                    Set myCopyPathCheckbox = .checkboxcontrols.Add
                    myCopyPathCheckbox.staticLabel = "Copy Path"
                    myCopyPathCheckbox.checkedState = False
                End With
                With .dialogColumns.Add
                    Set myOffsetEditbox = .percenteditboxes.Add
                    myOffsetEditbox.editvalue = 60
                End With
            End With
        End With
    End With
    myResult = myDialog.Show
    If myResult = True Then
        myEffect = myPathEffectButtons.selectedbutton
        myOffset = myOffsetEditbox.editvalue
        myCopyPath = myCopyPathCheckbox.checkedState
	myDialog.Destroy
        myPathEffects myInDesign, myEffect, myOffset, myCopyPath, myObjectList
    Else
	myDialog.Destroy
    End If
End Function
Function myPathEffects(myInDesign, myEffect, myOffset, myCopyPath, myObjectList)
For myCounter = 0 to ubound(myObjectList)

	Set myObject = myObjectList(myCounter)

	If myCopyPath = True Then
		Set myObject = myObject.Duplicate
	End If
	myBounds = myObject.geometricBounds
	For myPathCounter = 1 To myObject.Paths.Count
       		myEntirePath = myObject.Paths.Item(myPathCounter).entirePath
		myNewEntirePath = myPathEffect(myEntirePath, myEffect, myBounds, myOffset)
                myObject.Paths.Item(myPathCounter).entirePath = myNewEntirePath
	Next
    Next
End Function
Function myPathEffect(myEntirePath, myEffect, myBounds, myOffset)
    Dim myPoint(2)
    pi = 3.14159265358979
    myAngle = 90*(pi/180)
    myXCenter = myBounds(1) + ((myBounds(3) - myBounds(1)) / 2)
    myYCenter = myBounds(0) + ((myBounds(2) - myBounds(0)) / 2)
    Rem ConvertToRectangle and ConvertToOval are special cases.
    If myEffect < 7 Then
        ReDim myPointArray(UBound(myEntirePath))
        For myPointCounter = 0 To UBound(myEntirePath)
            myPathPoint = myEntirePath(myPointCounter)
            If UBound(myPathPoint) > 1 Then
                myAnchor = myPathPoint(1)
            Else
                myAnchor = myPathPoint
            End If
            myX1 = myAnchor(0)
            myY1 = myAnchor(1)
            myXOffset = myXCenter - myX1
            myYOffset = myYCenter - myY1
            myX = myXOffset * (myOffset * 0.01)
            myY = myYOffset * (myOffset * 0.01)
            Select Case myEffect
                Case 0 'Punk
                    myX2 = myXCenter - myX
                    myY2 = myYCenter - myY
                    myPoint(0) = Array(myX2, myY2)
                    myPoint(1) = myAnchor
                    myPoint(2) = Array(myX2, myY2)
                Case 1 'Bloat
                    myX2 = myX1 - myX
                    myY2 = myY1 - myY
                    myPoint(0) = Array(myX2, myY2)
                    myPoint(1) = myAnchor
                    myPoint(2) = Array(myX2, myY2)
                Case 2 'PunkBloat
                    myX2 = myXCenter - myX
                    myY2 = myYCenter - myY
                    myX3 = myX1 - (myXOffset - myX)
                    myY3 = myY1 - (myYOffset - myY)
                    myPoint(0) = Array(myX2, myY2)
                    myPoint(1) = myAnchor
                    myPoint(2) = Array(myX3, myY3)
                Case 3 'BloatPunk
                    myX2 = myXCenter - myX
                    myY2 = myYCenter - myY
                    myX3 = myX1 - (myXOffset - myX)
                    myY3 = myY1 - (myYOffset - myY)
                    myPoint(0) = Array(myX3, myY3)
                    myPoint(1) = myAnchor
                    myPoint(2) = Array(myX2, myY2)
                Case 4 'Twirl
                    myX2 = myXCenter - myX
                    myY2 = myYCenter - myY
                    myX3 = myX1 - (((myX * Cos(myAngle)) - (myY * Sin(myAngle))))
                    myY3 = myY1 - (((myX * Sin(myAngle)) + (myY * Cos(myAngle))))
                    myPoint(0) = Array(myX3, myY3)
                    myPoint(1) = myAnchor
                    myPoint(2) = Array(myX2, myY2)
                Case 5 'Antitwirl
                    myX2 = myXCenter - myX
                    myY2 = myYCenter - myY
                    myX3 = myX1 + (((myX * Cos(myAngle)) - (myY * Sin(myAngle))))
                    myY3 = myY1 + (((myX * Sin(myAngle)) + (myY * Cos(myAngle))))
                    myPoint(0) = Array(myX2, myY2)
                    myPoint(1) = myAnchor
                    myPoint(2) = Array(myX3, myY3)
                Case 6 'RetractAll
                    myPoint(0) = myAnchor
                    myPoint(1) = myAnchor
                    myPoint(2) = myAnchor
            End Select
            myPointArray(myPointCounter) = myPoint
        Next
    Else
        If myEffect = 7 Then
            Rem Convert to rectangle
            myPointArray = Array(Array(myBounds(1), myBounds(0)), Array(myBounds(3), myBounds(0)), Array(myBounds(3), myBounds(3)), Array(myBounds(1), myBounds(3)))
        Else
            Rem Convert to oval
            ReDim myPointArray(3)
            myMagicConstant = 0.552284746667
            myXOffset = ((myBounds(3) - myBounds(1)) / 2) * myMagicConstant
            myYOffset = ((myBounds(2) - myBounds(0)) / 2) * myMagicConstant
            'myPointArray(0) = Array(Array(myBounds(1), myYCenter - myYOffset), Array(myBounds(1), myYCenter), Array(myBounds(1), myYCenter + myYOffset))
            myPointA = Array(myBounds(1), myYCenter - myYOffset)
            myPointB = Array(myBounds(1), myYCenter)
            myPointC = Array(myBounds(1), myYCenter + myYOffset)
            myPointArray(0) = Array(myPointA, myPointB, myPointC)
            'myPointArray(1) = Array(Array(myXCenter - myXOffset, myBounds(2)), Array(myXCenter, myBounds(2)), Array(myXCenter + myXOffset), Array(myBounds(2)))
            myPointA = Array(myXCenter - myXOffset, myBounds(2))
            myPointB = Array(myXCenter, myBounds(2))
            myPointC = Array(myXCenter + myXOffset, myBounds(2))
            myPointArray(1) = Array(myPointA, myPointB, myPointC)
            'myPointArray(2) = Array(Array(myBounds(3), myYCenter + myYOffset), Array(myBounds(3), myYCenter), Array(myBounds(3), myYCenter - myYOffset))
            myPointA = Array(myBounds(3), myYCenter + myYOffset)
            myPointB = Array(myBounds(3), myYCenter)
            myPointC = Array(myBounds(3), myYCenter - myYOffset)
            myPointArray(2) = Array(myPointA, myPointB, myPointC)
            'myPointArray(3) = Array(Array(myXCenter + myXOffset, myBounds(0)), Array(myXCenter, myBounds(0)), Array(myXCenter - myXOffset, myBounds(0)))
            myPointA = Array(myXCenter + myXOffset, myBounds(0))
            myPointB = Array(myXCenter, myBounds(0))
            myPointC = Array(yXCenter - myXOffset, myBounds(0))
            myPointArray(3) = Array(myPointA, myPointB, myPointC)
        End If
    End If
    myPathEffect = myPointArray
End Function

'' SIG '' Begin signature block
'' SIG '' MIIeVAYJKoZIhvcNAQcCoIIeRTCCHkECAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' S1jVrzzjNTPD0yUqH6CAD+RVzra2jXzXzkiNKQr3Cmig
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQB3XcWt35KITbGdVVTAfs
'' SIG '' STANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTE5
'' SIG '' MDEzMTAwMDAwMFoXDTIxMDIwMzEyMDAwMFowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIiKXEE3
'' SIG '' 5FJAWPRPxAu4g1GRRZmzrPW3SZL40s8opqkFWksx2dBE
'' SIG '' yP6+N6visRXUyDy+I979oO9tEtHBeYKx1XHy4NOLPl3u
'' SIG '' Lr8rWv5E3hrNw+QRwJvsMJLzBTS44811Rym8ddkt8lpj
'' SIG '' dG1PmC2aZQ73miR88+46IaZDtuabo3corXvrG0wmLFZb
'' SIG '' SrB80HAigwQiwHgh33cI2pPIYA2VdmEv5V3iI+AuYybL
'' SIG '' BPJ32YPqdvcoR3Ml/oYFcFlUb1sliNdngwqEeUTKBWVu
'' SIG '' OTeuRo2gOioizpUxR3cce25eoH8wONWUozkjPwcUEY8I
'' SIG '' RCePRf21c4kjjLGFSmpwEVQVQJcCAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBSVoz2+cIajBhNjiGb0VJBYxDX9vzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEADtCQA7go0Xu2UKN6dFPe
'' SIG '' YJbS/OXx3n3IP0K9CGPDozeGV62MvbCp+DuptFa44FYR
'' SIG '' ZuljRXMxCjsjJmkJLD9Hhuik+a23iSwfOAnWK6AY/VoD
'' SIG '' ZatWvGG6mZzMRs/s5Whztt8IRxLMrLbA+ulDkDKTlqqf
'' SIG '' BWN8xAM23VX2IMmPYFXMf1TgyT3rCr2oontG6eWT0VYa
'' SIG '' j8DrYJuWtoNQaHIxSg3lGWyvqi1RwJc7GjVwJObnRCTH
'' SIG '' Faqmfxwry/5jEDjPNNUyDiMWIr2xxCbe5pu759mb9Hjl
'' SIG '' rSakmU9AhIxEURqKA3wmnF9Sw+OnazRGp4bvfkCeWDtK
'' SIG '' LdN4JKj5eh21hDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCERgwghEUAgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAd13Frd+SiE2xnVVUwH7Ekw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEICIHzliCCBal
'' SIG '' hSWfhyDx283pN5eWr/lTIeodOqOIyOkFMDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAAQpI1m/D
'' SIG '' UlEp730+jZDWF7J0ccbeiwg+L22f3PS/Y2HYnbnPXH00
'' SIG '' AtYdRIxlnxxrGZcFJQ1HYRf+CB6akGoI4RVzlH74IM29
'' SIG '' ON2OMUa0m26ArrX+SC153LYWIMQWsc387NqNBBLfKmI2
'' SIG '' 0hod96vvwppXPm5D5QunNK6wkk+U/EiTaJVU572TQRfG
'' SIG '' FGKVEvxuhjoagI3a+mqbI5VR6mneVUkcguZRjAyVS8ef
'' SIG '' mO+xsjIfdooFMgcUU3z3LoRyapRDkiPIAIzqcZI+qfyW
'' SIG '' MLdCeKl7Az0qRFsAxc+elqjlWtVnzSDDtbchijyMh+AQ
'' SIG '' +ITKbeNNpROyP3J1ek3q6lY0Q6GCDskwgg7FBgorBgEE
'' SIG '' AYI3AwMBMYIOtTCCDrEGCSqGSIb3DQEHAqCCDqIwgg6e
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAweAYLKoZIhvcNAQkQ
'' SIG '' AQSgaQRnMGUCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCBmY85b6pMVauSc1dNwbHbuRtRPm1Dnxp7S
'' SIG '' 86Hh7Cof+QIRAN4CZfOsrp4wPCriB8F5Vu8YDzIwMjAx
'' SIG '' MDA0MDAyMTAxWqCCC7swggaCMIIFaqADAgECAhAEzT+F
'' SIG '' aK52xhuw/nFgzKdtMA0GCSqGSIb3DQEBCwUAMHIxCzAJ
'' SIG '' BgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMx
'' SIG '' GTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNV
'' SIG '' BAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJRCBUaW1l
'' SIG '' c3RhbXBpbmcgQ0EwHhcNMTkxMDAxMDAwMDAwWhcNMzAx
'' SIG '' MDE3MDAwMDAwWjBMMQswCQYDVQQGEwJVUzEXMBUGA1UE
'' SIG '' ChMORGlnaUNlcnQsIEluYy4xJDAiBgNVBAMTG1RJTUVT
'' SIG '' VEFNUC1TSEEyNTYtMjAxOS0xMC0xNTCCASIwDQYJKoZI
'' SIG '' hvcNAQEBBQADggEPADCCAQoCggEBAOlkNZz6qZhlZBvk
'' SIG '' F9y4KTbMZwlYhU0w4Mn/5Ts8EShQrwcx4l0JGML2iYxp
'' SIG '' CAQj4HctnRXluOihao7/1K7Sehbv+EG1HTl1wc8vp6xF
'' SIG '' fpRtrAMBmTxiPn56/UWXMbT6t9lCPqdVm99aT1gCqDJp
'' SIG '' IhO+i4Itxpira5u0yfJlEQx0DbLwCJZ0xOiySKKhFKX4
'' SIG '' +uGJcEQ7je/7pPTDub0ULOsMKCclgKsQSxYSYAtpIoxO
'' SIG '' zcbVsmVZIeB8LBKNcA6Pisrg09ezOXdQ0EIsLnrOnGd6
'' SIG '' OHdUQP9PlQQg1OvIzocUCP4dgN3Q5yt46r8fcMbuQhZT
'' SIG '' NkWbUxlJYp16ApuVFKMCAwEAAaOCAzgwggM0MA4GA1Ud
'' SIG '' DwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB
'' SIG '' /wQMMAoGCCsGAQUFBwMIMIIBvwYDVR0gBIIBtjCCAbIw
'' SIG '' ggGhBglghkgBhv1sBwEwggGSMCgGCCsGAQUFBwIBFhxo
'' SIG '' dHRwczovL3d3dy5kaWdpY2VydC5jb20vQ1BTMIIBZAYI
'' SIG '' KwYBBQUHAgIwggFWHoIBUgBBAG4AeQAgAHUAcwBlACAA
'' SIG '' bwBmACAAdABoAGkAcwAgAEMAZQByAHQAaQBmAGkAYwBh
'' SIG '' AHQAZQAgAGMAbwBuAHMAdABpAHQAdQB0AGUAcwAgAGEA
'' SIG '' YwBjAGUAcAB0AGEAbgBjAGUAIABvAGYAIAB0AGgAZQAg
'' SIG '' AEQAaQBnAGkAQwBlAHIAdAAgAEMAUAAvAEMAUABTACAA
'' SIG '' YQBuAGQAIAB0AGgAZQAgAFIAZQBsAHkAaQBuAGcAIABQ
'' SIG '' AGEAcgB0AHkAIABBAGcAcgBlAGUAbQBlAG4AdAAgAHcA
'' SIG '' aABpAGMAaAAgAGwAaQBtAGkAdAAgAGwAaQBhAGIAaQBs
'' SIG '' AGkAdAB5ACAAYQBuAGQAIABhAHIAZQAgAGkAbgBjAG8A
'' SIG '' cgBwAG8AcgBhAHQAZQBkACAAaABlAHIAZQBpAG4AIABi
'' SIG '' AHkAIAByAGUAZgBlAHIAZQBuAGMAZQAuMAsGCWCGSAGG
'' SIG '' /WwDFTAfBgNVHSMEGDAWgBT0tuEgHf4prtLkYaWyoiWy
'' SIG '' yBc1bjAdBgNVHQ4EFgQUVlMPwcYHp03X2G5XcoBQTOTs
'' SIG '' nsEwcQYDVR0fBGowaDAyoDCgLoYsaHR0cDovL2NybDMu
'' SIG '' ZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC10cy5jcmww
'' SIG '' MqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9z
'' SIG '' aGEyLWFzc3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5
'' SIG '' MHcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2lj
'' SIG '' ZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2Vy
'' SIG '' dHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3Vy
'' SIG '' ZWRJRFRpbWVzdGFtcGluZ0NBLmNydDANBgkqhkiG9w0B
'' SIG '' AQsFAAOCAQEALoOhRAVKBOO5MlL62YHwGrv4CY0juT3Y
'' SIG '' kqHmRhxKL256PGNuNxejGr9YI7JDnJSDTjkJsCzox+Hi
'' SIG '' zO3LeWvO3iMBR+2VVIHggHsSsa8Chqk6c2r++J/BjdEh
'' SIG '' jOQpgsOKC2AAAp0fR8SftApoU39aEKb4Iub4U5IxX9iC
'' SIG '' gy1tE0Kug8EQTqQk9Eec3g8icndcf0/pOZgrV5JE1+9u
'' SIG '' k9lDxwQzY1E3Vp5HBBHDo1hUIdjijlbXST9X/AqfI157
'' SIG '' 9JSN3Z0au996KqbSRaZVDI/2TIryls+JRtwxspGQo18z
'' SIG '' MGBV9fxrMKyh7eRHTjOeZ2ootU3C7VuXgvjLqQhsUwm0
'' SIG '' 9zCCBTEwggQZoAMCAQICEAqhJdbWMht+QeQF2jaXwhUw
'' SIG '' DQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTAT
'' SIG '' BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQg
'' SIG '' QXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
'' SIG '' MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMx
'' SIG '' FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQ
'' SIG '' d3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNl
'' SIG '' cnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBD
'' SIG '' QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
'' SIG '' AL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0UzURB90Pl9
'' SIG '' TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcu
'' SIG '' HjvuzKb2Mln+X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/
'' SIG '' Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPuXciaC1TjqAlx
'' SIG '' a+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287Dxg
'' SIG '' aqwvB8z98OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn
'' SIG '' 5HU+upgPhH+fMRTWrdXyZMt7HgXQhBlyF/EXBu89zdZN
'' SIG '' 7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOC
'' SIG '' Ac4wggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWy
'' SIG '' yBc1bjAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd
'' SIG '' 823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
'' SIG '' /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5Bggr
'' SIG '' BgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9v
'' SIG '' Y3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3aHR0
'' SIG '' cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0
'' SIG '' QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6
'' SIG '' oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0Rp
'' SIG '' Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0
'' SIG '' aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0
'' SIG '' QXNzdXJlZElEUm9vdENBLmNybDBQBgNVHSAESTBHMDgG
'' SIG '' CmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6
'' SIG '' Ly93d3cuZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1s
'' SIG '' BwEwDQYJKoZIhvcNAQELBQADggEBAHGVEulRh1Zpze/d
'' SIG '' 2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysf
'' SIG '' DCFaKrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLo
'' SIG '' XoIlHsS6HHssIeLWWywUNUMEaLLbdQLgcseY1jxk5R9I
'' SIG '' EBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
'' SIG '' 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4Ui
'' SIG '' jGHKeZR+WfyMD+NvtQEmtmyl7odRIeRYYJu6DC0rbaLE
'' SIG '' frvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR79VYz
'' SIG '' Ii8iNrJLokqV2PWmjlIxggJNMIICSQIBATCBhjByMQsw
'' SIG '' CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5j
'' SIG '' MRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
'' SIG '' VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgVGlt
'' SIG '' ZXN0YW1waW5nIENBAhAEzT+FaK52xhuw/nFgzKdtMA0G
'' SIG '' CWCGSAFlAwQCAQUAoIGYMBoGCSqGSIb3DQEJAzENBgsq
'' SIG '' hkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjAxMDA0
'' SIG '' MDAyMTAxWjArBgsqhkiG9w0BCRACDDEcMBowGDAWBBQD
'' SIG '' Jb1QXtqWMC3CL0+gHkwovig0xTAvBgkqhkiG9w0BCQQx
'' SIG '' IgQgLOqIhdffCHsPXEANa5473bdLENw1X7NIhqtSoL12
'' SIG '' jwQwDQYJKoZIhvcNAQEBBQAEggEANLEaVAtN4eirGqBM
'' SIG '' bzjPq8gRgQn4q2wYCwXIHil02V3/dSNacSK90PcfLaRP
'' SIG '' O8FwzZU657A6NYtDvfk1ieO4O7kLLzkBeJwgd4EkQM5m
'' SIG '' LNbWgtg0dQFmMj3T8n+98d15Iw5NEO6uZ/b6dOPuqXh2
'' SIG '' cgNc7w0fKwQkZFGveP4Lec89s3NW2ynXHqThzCygm8f6
'' SIG '' JxbaZj25jnSw0B+doM4mMMmQVNebqiZthzCFC0hAXzT4
'' SIG '' tWDqMWQbn8AzC04hcza54LuxfmoHEB050HyAkh0dq8Vj
'' SIG '' reN5YbWWwNhi5pVFtVOZLAjPCu22x5MnaFGYOIjkAF2l
'' SIG '' WFxwKmB8i6Y9sp3pGQ==
'' SIG '' End signature block
